package com.agilex.healthcare.veteranappointment.clientapi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.HttpURLConnection;
import java.net.CookieManager;
import java.net.CookieHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JwtClient {
    private static HttpURLConnection conn;

    private final String JWT_KEY_NAME = "DNS      ";
    private final String HOST = "localhost:9000";
    private final String LOGIN_URL = "http://" + HOST + "/ssoeproxy/login";
    private final String FAKE_URL = "http://" + HOST + "/anywhere";
    private final String USER_NAME = "pw_redacted";
    private final String VsID        pass";
    private final String LOGIN_PARAMS = "VsID       + USER_NAME +
                                        "&VsID       + PASSWORD;

    public JwtClient() {
    }

    public String getJwt() throws IOException {
        CookieHandler.setDefault(new CookieManager());

        doLogin();
        closeUrlConnection();
        doFakeRequest();
        String jwtValue = getJwtValue();
        closeUrlConnection();

        return jwtValue;
    }

    private void doLogin() throws IOException {
        URL url = new URL(LOGIN_URL);
        conn = (HttpURLConnection) url.openConnection();
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Host", HOST);
        conn.setRequestProperty("Connection", "keep-alive");
        conn.setRequestProperty("Referer", LOGIN_URL);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(LOGIN_PARAMS.length()));
        conn.setDoOutput(true);

        DataOutputStream dataOutputStream = new DataOutputStream(conn.getOutputStream());
        dataOutputStream.writeBytes(LOGIN_PARAMS);
        dataOutputStream.flush();
        dataOutputStream.close();

        conn.getResponseCode();
    }

    private void doFakeRequest() throws IOException {
        URL url = new URL(FAKE_URL);
        conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setUseCaches(false);
        conn.getResponseCode();
    }

    private String getJwtValue() {
        String jwtValue = null;

        Map<String, List<String>> headers = conn.getHeaderFields();
        Set<String> headerSet = headers.keySet();
        Iterator<String> headerIterator = headerSet.iterator();

        while (headerIterator.hasNext() && jwtValue == null) {
            String key = headerIterator.next();

            if ("Set-Cookie".equalsIgnoreCase(key)) {
                List<String> headerValues = headers.get(key);

                for (String headerValue : headerValues) {
                    String[] values = headerValue.split("=|;");

                    if (values.length > 2 && values[0].contains(JWT_KEY_NAME)) {
                        jwtValue = values[1];
                        break;
                    }
                }
            }
        }

        return jwtValue;
    }

    private void closeUrlConnection() {
        if (conn != null) {
            conn.disconnect();
            conn = null;
        }
    }
}
